C********************************************************************

      SUBROUTINE USRDMG(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME,NRT)

C********************************************************************
C
C     User damage model
C
C     INPUT :
C
C      NRT       =   DAMAGE MODEL NUMBER
C      STS       =   STRESS
C      EFSTS     =   EFFECTIVE STRESS
C      EFEPS     =   EFFECTIVE STRAIN RATE
C      DAMAG     =   PREVIOUS ACCUMULATED DAMAGE
C      STRLMT    =   STRAIN LIMIT
C      DTIME     =   TIME INCREMENT
C
C     OUTPUT
C
C      DAMAG     =   NEW VALUE OF ACCUMULATED DAMAGE
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
      NROUTE = ABS(NRT)
      GO TO (510,520,530,540,550),NROUTE
C
  510 CALL USRDM1(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
      RETURN
C
  520 CALL USRDM2(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
      RETURN
C
  530 CALL USRDM3(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
      RETURN
C
  540 CALL USRDM4(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
      RETURN
C
  550 CALL USRDM5(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
      RETURN
C
C  TO BE CONTINUED BY USER
C
      END
C********************************************************************

      SUBROUTINE USRDM1(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)

C********************************************************************
C
C     User damage model
C
C     This routine is used to demonstrate the implementation of
C     damage routine.  All the real variables should be double 
C     precision. the definition of arguments are described as follows
C
C     INPUT :
C
C      NRT       =   DAMAGE MODEL NUMBER
C      STS       =   STRESS
C      EFSTS     =   EFFECTIVE STRESS
C      EFEPS     =   EFFECTIVE STRAIN RATE
C      DAMAG     =   PREVIOUS ACCUMULATED DAMAGE
C      STRLMT    =   STRAIN LIMIT
C      DTIME     =   TIME INCREMENT
C
C     OUTPUT
C
C      DAMAG     =   NEW VALUE OF ACCUMULATED DAMAGE
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C  Additional element data available from the common block ELMCOM
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable array at the begining of step
C         USRE2   : Element user variable array at the end of the step
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP
      DIMENSION STS(4)
C
C
C     EXAMPLE :
C    
C     PRNSTS = Maximum principal stress
C
C     New value of damage is found by accumulating damage using
C     the unmodified Cockroft & Latham model
C
C
      DNT  =  DSQRT((STS(1)-STS(2))**2 + 4. * STS(4)**2)
      S1  =  ((STS(1) + STS(2)) + DNT) * 0.5
      S2  =  ((STS(1) + STS(2)) - DNT) * 0.5
C
C     Calcualte principal stress 
C
      PRNSTS  =  S1
      IF(PRNSTS .LT. S2) PRNSTS  =  S2
C
C     Calculate value of damage
C
      DAMAG = DAMAG + (PRNSTS*EFEPS*DTIME)
C
      RETURN
      END
C********************************************************************

      SUBROUTINE USRDM2(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)
C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C     SEE "USRDM1" FOR DETAILED IMPLEMENTATION
C
C  Additional element data available from the common block ELMCOM
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable array at the begining of step
C         USRE2   : Element user variable array at the end of the step
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP
      DIMENSION STS(4)

      RETURN
      END
C********************************************************************

      SUBROUTINE USRDM3(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C     SEE "USRDM1" FOR DETAILED IMPLEMENTATION
C
C  Additional element data available from the common block ELMCOM
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable array at the begining of step
C         USRE2   : Element user variable array at the end of the step
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP
      DIMENSION STS(4)

      RETURN
      END
C********************************************************************

      SUBROUTINE USRDM4(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C     SEE "USRDM1" FOR DETAILED IMPLEMENTATION
C
C  Additional element data available from the common block ELMCOM
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable array at the begining of step
C         USRE2   : Element user variable array at the end of the step
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP
      DIMENSION STS(4)

      RETURN
      END
C********************************************************************

      SUBROUTINE USRDM5(STS,EFSTS,EFEPS,DAMAG,STRLMT,DTIME)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT INTEGER*4 (I,J,K,L,M,N), REAL*8 (A-H,O-Z)
C
C     SEE "USRDM1" FOR DETAILED IMPLEMENTATION
C
C  Additional element data available from the common block ELMCOM
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable array at the begining of step
C         USRE2   : Element user variable array at the end of the step
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP
      DIMENSION STS(4)
C
      RETURN
      END

C********************************************************************
